; FillVRAM
; bc - Bytes to Fill
; de - VRAM address
; a  - Fill byte
FillVRAM
	di

	; Increment the high order byte of the count.
	inc		b
	
	; Set the starting address
	ld		a, e
	out		(VDPCONTROL), a

	ld		a, d
	or		0x40
	out		(VDPCONTROL), a
		
1
	out		(VDPDATA), a
	
	dec		c
	jr		nz, 1b
	
	dec		b
	jr		nz, 1b
	
	ei
	
	ret

; WriteVRAM
; bc - Bytes to Fill
; de - VRAM address
; hl - Source buffer
WriteVRAM
	di
	
	; Increment the high order byte of the count.
	inc		b
	
	; Set the VRAM address
	ld		a, e
	out		(VDPCONTROL), a

	ld		a, d
	or		0x40
	out		(VDPCONTROL), a
	
1
	ld		a, (hl)	
	out		(VDPDATA), a
	
	inc		hl

	dec		c
	jr		nz, 1b
	
	dec		b
	jr		nz, 1b
	
	ei
	
	ret
	
; Initialize ram used by VDP routines
InitVDPData
	ld		a, 0x80
	ld		(Register2), a
	
	ret
	
; Setup mode 2, 16k VRAM, screen off, interrupts off, 8x8 sprites expansion disabled, background color #0.
; Pattern table at 0x0000 (0x1800 bytes)
; Pattern name table at 0x1800 (0x300 bytes)
; Color table at 0x2000 (0x1800 bytes)
; Sprite attribute table 0x1E00 (0x80 bytes)
; Sprite pattern table 0x3800 (0x800 bytes) 
SetupVDP:
	di
	
	; Set registers
	ld		hl, VDPTable
	ld		c, 0x80
	
1
	ld		a, (hl)
	out		(VDPCONTROL), a
	
	ld		a, c
	out		(VDPCONTROL), a
	
	inc		hl
	inc		c
	
	cp		a, 0x87	
	jr		nz, 1b
	
	ei
	
	ret
	
VDPTable:
	; Register 0.  Graphics mode 2
	db	0x02
	
	; Register 1. 16k mode.
	db	0x80
	
	; Register 2
	db	0x1800 / 0x400
	
	; Register 3, Must be 0x0000 or 0x2000 in graphics mode 2.
	db	(0x2000 / 0x40) | 0x1F
	
	; Register 4, Must be 0x0000 or 0x2000 in graphics mode 2.
	db	0x0000 / 0x800

	; Register 5
	db	0x1E00 / 0x80
	
	; Register 6
	db	0x3800 / 0x800
	
	; Register 7
	db	0x00

; Turn the screen on
ScreenOn
	di
	
	ld		a, (Register2)
	or		a, 0x40
	ld		(Register2), a
	
	out		(VDPCONTROL), a
	
	ld		a, 0x81
	out		(VDPCONTROL), a
	
	ei
	
	ret

; Turn the screen off
ScreenOff
	di
	
	ld		a, (Register2)
	and		a, ~0x40
	ld		(Register2), a
	
	out		(VDPCONTROL), a
	
	ld		a, 0x81
	out		(VDPCONTROL), a
	
	ei
	
	ret
	
; Turn the vblank interrupt on
VBlankOn
	di
	
	ld		a, (Register2)
	or		a, 0x20
	ld		(Register2), a
	
	out		(VDPCONTROL), a
	
	ld		a, 0x81
	out		(VDPCONTROL), a
	
	ei
	
	ret

; Turn the vblank interrupt off
VBlankOff
	di
	
	ld		a, (Register2)
	and		a, ~0x20
	ld		(Register2), a
	
	out		(VDPCONTROL), a
	
	ld		a, 0x81
	out		(VDPCONTROL), a
	
	ei
	
	ret
	
; Update tilemap
; hl - Tilemap pointer
UpdateMap:
	di
	
	; Setup a write to the name table
	xor		a
	out		(VDPCONTROL), a

	ld		a, 0x18 | 0x40
	out		(VDPCONTROL), a
	
	; Create the offset value
	ld		d, 0
	ld		e, 256-32

	; Draw each row
	ld		b, 24
	
1
	; Draw a row of tiles
	ld		c, 32

2
	ld		a, (hl)
	out		(VDPDATA), a
	
	inc		hl
	
	dec		c
	jr		nz, 2b
	
	add		hl, de
	
	dec		b
	jr		nz, 1b
	
	ei
	
	ret
	
	map RAM_START	
MapPointer		# 2
ScrollX			# 1
ScrollY			# 1
Register2		# 1
DoMapUpdate		# 1
VBlankFlag		# 1
