include "Defines.inc"
include "Coleco.inc"

; *******************************
; DEFAULT COLECOVISION CARTRIDGE HEADER
; *******************************
	output	"Polka.rom"
	defpage	0, 0x8000, 0x8000
	page	0

; Cartridge starting address
CARTRIDGE:
	dw	0x55AA

; Pointer to sprite name table	
LOCAL_SPR_TABLE:
	dw	0

; Pointer to sprite order table	
SPRITE_ORDER:
	dw	0

; Pointer to temporary storage in RAM	
WORK_BUFFER:
	dw	0
	
; Pointer to controller memory map
CONTROLLER_MAP:
	dw	0

; Pointer to game start code	
START_GAME:
	dw	Start

; rst Reset $08 soft vector	
RST_8H_RAM:
	reti
	
	nop

; Reset $10 soft vector	
RST_10H_RAM:
	reti
	
	nop

; Reset 18 soft vector	
RST_18H_RAM:
	reti
	
	nop

; Reset 20 soft vector	
RST_20H_RAM:
	reti
	
	nop
	
; Reset 28 soft vector
RST_28H_RAM:
	reti
	
	nop

; Reset 30 soft vector	
RST_30H_RAM:
	reti
	
	nop

	; Software interrupt vector (RST 38H)
IRQ_INT_VECT:
	reti
	
	nop

; NMI soft vector
NMI_INT_VECT:
	jp		NMI

GAME_NAME:
	db	"POLKA EXAMPLE/RASTER SOFTWARE/2011"

NMI:
	push	hl
	push	af
	
	call	READ_REGISTER
	
	; Signal that the VBlank occurred
	ld		a, 1
	ld		(VBlankFlag), a

	; Check to see if the map should be updated
	ld		a, (DoMapUpdate)
	or		a
	jr		z, 1f
	
	; Reset the do map update flag
	xor		a
	ld		(DoMapUpdate), a
	
	; Transfer name table
	ld		hl, (MapPointer)
	call	UpdateMap

1
	pop		af
	pop		hl
	
	retn

Start:
	im		1
	
	; Initialize VDP data
	call	InitVDPData
	
	; Turn screen and interrupts off
	call	ScreenOff
	call	VBlankOff
	
	; Setup VDP
	call	SetupVDP
	
	; Clear VRAM
	ld		de, 0x0000
	ld		bc, 0x4000
	xor		a
	call	FillVRAM
	
	; Transfer pattern table
	ld		hl, PatternTable
	ld		de, 0x0000
	ld		bc, 2048
	
	call	WriteVRAM
	
	; Transfer color table
	ld		hl, ColorTable
	ld		de, 0x2000
	ld		bc, 2048
	
	call	WriteVRAM
	
	; Transfer name table
	ld		hl, NameTable
	ld		(MapPointer), hl
	call	UpdateMap

	; Reset scroll position
	xor		a
	ld		(ScrollX), a
	ld		(ScrollY), a
	
	; Reset the do map update flag
	ld		(DoMapUpdate), a
	
	; Reset VBlank flag
	ld		(VBlankFlag), a
	
	; Setup input
	call	SetupInput
	
	; Turn screen and interrupts on
	call	ScreenOn
	call	VBlankOn
	
1
	; Check VBlank flag
	ld		a, (VBlankFlag)
	or		a
	jr		z, 1b

2
	; Reset VBlank flag
	xor		a
	ld		(VBlankFlag), a

	; Update input
	call	UpdateInput
	
	jr		1b
	
; Setup input
SetupInput:
	; Enable joystick mode
	ld		a, 0xFF
	out		(JOYENABLE), a
	
	ret
	
; Update input
UpdateInput:
	; Load scroll position
	ld		a, (ScrollY)
	ld		b, a
	ld		a, (ScrollX)
	ld		c, a
	
	; Read joystick 1
	in		a, (JOY1DATA)
	
	; Invert input
	cpl
	
	; Mask out all input except the joystick
	and		0x0F	
	jr		z, 5f
	
	; Transfer the joystick data into an unused register
	ld		d, a
	
	; Test up
	bit		0, d
	jr		z, 1f
	
	ld		a, b
	cp		a, 0
	jr		z, 1f
	
	; Scroll up
	dec		b
	
	; Update map
	ld		e, 1

1
	; Test right
	bit		1, d
	jr		z, 2f
	
	ld		a, c
	cp		a, 223
	jr		nc, 2f
	
	; Scroll right
	inc		c
	
	; Update map
	ld		e, 1

2
	; Test down
	bit		2, d
	jr		z, 3f

	ld		a, b
	cp		a, 71
	jr		nc, 3f
	
	; Scroll down
	inc		b
	
	; Update map
	ld		e, 1

3	
	; Test left
	bit		3, d
	jr		z, 4f
	
	ld		a, c
	cp		a, 0
	jr		z, 4f
	
	; Scroll left
	dec		c
	
	; Update map
	ld		e, 1

4
	ld		a, e
	or		a
	
	; See if the scroll position was updated
	jr		z, 5f
	
	; Update scroll positions
	ld		a, b
	ld		(ScrollY), a
	ld		a, c
	ld		(ScrollX), a
	
	; Update map pointer
	ld		hl, NameTable
	add		hl, bc
	
	ld		(MapPointer), hl
	
	; Force map update
	ld		a, 1
	ld		(DoMapUpdate), a

5
	ret
	
include "Routines.asm"

; Data
PatternTable:
	incbin	"Data\Tiles.pat"
	
ColorTable:
	incbin	"Data\Tiles.col"
	
NameTable:
	incbin	"Data\Tiles.stg"
	
