//*****************************************************************
//* MSX SC4 to PPR (Polka 1.2) converter
//*****************************************************************

#include <stdio.h>
#include <stdlib.h>

typedef	unsigned char	BYTE;

void Usage();

int main(int argc, char *argv[])
{
	printf("MSX SC4 to PPR (Polka 1.2) converter.\n");

	if (argc < 3)
	{
		Usage();
	}

	FILE*	pHandle	= fopen(argv[1], "rb");
	
	if (NULL == pHandle)
	{
		printf("Unable to open SC4 file %s\n", argv[1]);

		exit(1);
	}
	
	fseek(pHandle, 0, SEEK_END);
	
	int	iLength	= ftell(pHandle);
	
	if (iLength != 32 + 2048 + 2048)
	{
		printf("Input file is not a SC4 file.\n");

		exit(1);
	}
	
	rewind(pHandle);
	
	BYTE*	pPal	= new BYTE[32];
	fread(pPal, 1, 32, pHandle);

	BYTE*	pPat	= new BYTE[2048];
	
	fread(pPat, 1, 2048, pHandle);
	
	for (int iLoop = 0; iLoop < 2048; ++iLoop)
	{
		int	iValue	= pPat[iLoop];		
		
		pPat[iLoop]	= (BYTE)(((iValue * 0x0802LU & 0x22110LU) | (iValue * 0x8020LU & 0x88440LU)) * 0x10101LU >> 16);
	}
	
	BYTE*	pCol	= new BYTE[2048];
	fread(pCol, 1, 2048, pHandle);

	for (int iLoop = 0; iLoop < 2048; ++iLoop)
	{
		BYTE	uValue1	= pCol[iLoop] & 0x0F;
		BYTE	uValue2	= pCol[iLoop] & 0xF0;
		
		pCol[iLoop]	= (uValue1 << 4) | (uValue2 >> 4);
	}
	
	fclose(pHandle);

	pHandle	= fopen(argv[2], "wb");
	
	if (NULL == pHandle)
	{
		printf("Unable to create PPR file %s\n", argv[1]);

		exit(1);
	}

	BYTE	uHeader[]	= {'P', 'O', 'L', 'K', 'A', 1, 0};
	
	fwrite(uHeader, 1, 7, pHandle);
	
	fwrite(pPat, 1, 2048, pHandle);
	
	fwrite(pCol, 1, 2048, pHandle);

	// Write dummy byte(?)
	BYTE	uValue	= 0;
	fwrite(&uValue, 1, 1, pHandle);
	
	fwrite(pPal, 1, 32, pHandle);

	// Write padding(?)
	for (int iLoop = 0; iLoop < 256; ++iLoop)
	{
		fwrite(&uValue, 1, 1, pHandle);
	}
	
	fclose(pHandle);
}

void Usage()
{
	printf("Command syntax is: SC4ToPPR Infile.sc4 Outfile.ppr\n");

	exit(1);
}
