; Setup mode 2, 16k VRAM, screen off, interrupts off, 8x8 sprites expansion disabled, background color #0.
; Pattern table at 0x0000 (0x1800 bytes)
; Pattern name table at 0x1800 (0x300 bytes)
; Color table at 0x2000 (0x1800 bytes)
; Sprite attribute table 0x1E00 (0x80 bytes)
; Sprite pattern table 0x3800 (0x800 bytes) 
SetupVDP:
	; Set registers
	ld		hl, VDPTable
	ld		c, 0x80
	
@SetupVDPLoop
	ld		a, (hl)
	out		(VDPCONTROL), a
	
	ld		a, c
	out		(VDPCONTROL), a
	
	inc		hl
	inc		c
	
	cp		a, 0x87	
	jr		nz, SetupVDPLoop
	
	retn
	
VDPTable:
	; Register 0.  Graphics mode 2
	db	0x02
	
	; Register 1. 16k mode.
	db	0xE0
	
	; Register 2
	db	0x1800 / 0x400
	
	; Register 3, Must be 0x0000 or 0x2000 in graphics mode 2.
	db	(0x2000 / 0x40) | 0x1F
	
	; Register 4, Must be 0x0000 or 0x2000 in graphics mode 2.
	db	0x0000 / 0x800

	; Register 5
	db	0x1E00 / 0x80
	
	; Register 6
	db	0x3800 / 0x800
	
	; Register 7
	db	0x00
