include "Defines.inc"
include "Coleco.inc"

; *******************************
; DEFAULT COLECOVISION CARTRIDGE HEADER
; *******************************
	output	"Polka.rom"
	defpage	0, 0x8000, 0x8000
	page	0

; Cartridge starting address
CARTRIDGE:
	dw	0x55AA

; Pointer to sprite name table	
LOCAL_SPR_TABLE:
	dw	0

; Pointer to sprite order table	
SPRITE_ORDER:
	dw	0

; Pointer to temporary storage in RAM	
WORK_BUFFER:
	dw	0
	
; Pointer to controller memory map
CONTROLLER_MAP:
	dw	0

; Pointer to game start code	
START_GAME:
	dw	Start

; rst Reset $08 soft vector	
RST_8H_RAM:
	reti
	
	nop

; Reset $10 soft vector	
RST_10H_RAM:
	reti
	
	nop

; Reset 18 soft vector	
RST_18H_RAM:
	reti
	
	nop

; Reset 20 soft vector	
RST_20H_RAM:
	reti
	
	nop
	
; Reset 28 soft vector
RST_28H_RAM:
	reti
	
	nop

; Reset 30 soft vector	
RST_30H_RAM:
	reti
	
	nop

	; Software interrupt vector (RST 38H)
IRQ_INT_VECT:
	reti
	
	nop

; NMI soft vector
NMI_INT_VECT:
	jp		NMI

GAME_NAME:
	db	"POLKA EXAMPLE/RASTER SOFTWARE/2011"

NMI:
	call	READ_REGISTER
	
	retn

Start:
	im		1
	
	; Clear VRAM
	ld		hl, 0x0000
	ld		de, 0x4000
	xor		a
	call	FILL_VRAM
	
	; Transfer pattern table
	ld		hl, PatternTable
	ld		de, 0x0000
	ld		bc, 2048
	
	call	WRITE_VRAM
	
	; Transfer color table
	ld		hl, ColorTable
	ld		de, 0x2000
	ld		bc, 2048
	
	call	WRITE_VRAM
	
	; Transfer name table
	ld		hl, NameTable
	ld		de, 0x1800
	ld		bc, 32 * 24
	
	call	WRITE_VRAM
	
	; Setup VDP
	call	SetupVDP
	
@Loop:
	jp		Loop

include "Routines.asm"

; Data
PatternTable:
	incbin	"Data\Tiles.pat"
	
ColorTable:
	incbin	"Data\Tiles.col"
	
NameTable:
	incbin	"Data\Tiles.stg"
	
