; *******************************
; LIST OF COLECOVISION SYMBOLS
; *******************************
AMERICA equ 0069h ; AMERICA 60 = NTSC, 50 = PAL
ASCII_TABLE equ 006Ah ; Pointer to uppercase ASCII pattern
NUMBER_TABLE equ 006Ch ; NUMBER_TABLE Pointer to numbers 0-9 pattern

; *******************************
; LIST OF OFFICIAL COLECOVISION BIOS CALLS
; *******************************
DECLSN equ 0190h ; Decrement low nibble (in UTILITY)
DECMSN equ 019Bh ; Decrement high nibble (in (UTILITY)
MSNTOLSN equ 01A6h ; Copy high nibble to low nibble (in UTILITY)
ADD816 equ 01B1h ; Add signed 8bit value A to 16bit [HL]
LEAVE_EFFECT equ 01D5h ; Called by a special sound effect function when done
PX_TO_PTRN_POS equ 07E8h ; Pixel to pattern plane position
PUT_FRAME equ 080Bh ; Copy a block of names to VRAM
GET_BKGRND equ 0898h ; Copy a block of names from VRAM to RAM
CALC_OFFSET equ 08C0h ; Returns DE := offset for the coordinates (E,D)
PLAY_SONGS equ 1F61h
REFLECT_VERTICAL equ 1F6Ah
REFLECT_HORIZONTAL equ 1F6Dh
ROTATE_90 equ 1F70h
ENLARGE equ 1F73h
CONTROLLER_SCAN equ 1F76h
DECODER equ 1F79h 
GAME_OPT equ 1F7Ch
LOAD_ASCII equ 1F7Fh 
FILL_VRAM equ 1F82h
MODE_1 equ 1F85h
UPDATE_SPINNER equ 1F88h 
INIT_TABLE equ 1FB8h
GET_VRAM equ 1FBBh
PUT_VRAM equ 1FBEh 
INIT_SPR_ORDER equ 1FC1h
WR_SPR_NM_TBL equ 1FC4h
INIT_TIMER equ 1FC7h
FREE_SIGNAL equ 1FCAh 
REQUEST_SIGNAL equ 1FCDh 
TEST_SIGNAL equ 1FD0h
TIME_MGR equ 1FD3h
TURN_OFF_SOUND equ 1FD6h
WRITE_REGISTER equ 1FD9h 
READ_REGISTER equ 1FDCh
WRITE_VRAM equ 1FDFh
READ_VRAM equ 1FE2h
INIT_WRITER equ 1FE5h 
WRITER equ 1FE8h 
POLLER equ 1FEBh
SOUND_INIT equ 1FEEh
PLAY_IT equ 1FF1h
SOUND_MAN equ 1FF4h 
ACTIVATE equ 1FF7h
PUTOBJ equ 1FFAh
RAND_GEN equ 1FFDh

; *******************************
; LIST OF UNOFFICIAL COLECOVISION BIOS CALLS
; *******************************
FREQ_SWEEP equ 00FCh ; Frequency sweep
ATN_SWEEP equ 012Fh ; Attenuation sweep
EFXOVER equ 02EEh ; (in PROCESS_DATA_AREA to get next note)

; *******************************
; DEFAULT COLECOVISION RAM MAP
; *******************************
PTR_LST_OF_SND_ADDRS equ 7020h ; Pointer to list of sound addrs
PTR_TO_S_ON_0 equ 7022h ; Pointer to song for Noise
PTR_TO_S_ON_1 equ 7024h ; Pointer to song for Tone#1
PTR_TO_S_ON_2 equ 7026h ; Pointer to song for Tone#2
PTR_TO_S_ON_3 equ 7028h ; Pointer to song for Tone#3
SAVE_CTRL equ 702Ah ; CTRL data (bype)
; -------------------------------------------
STACK equ 73B9h ; Beginning of the stack
PARAM_AREA equ 73BAh ; Common passing parameters area (PASCAL)
TIMER_LENGTH equ 73C0h ; Length of timer
TEST_SIG_NUM equ 73C2h ; Signal Code
VDP_MODE_WORD equ 73C3h ; Copy of data in the 1st 2 VDP registers
VDP_STATUS_BYTE equ 73C5h ; Contents of default NMI handler
DEFER_WRITES equ 73C6h ; Deferred sprites flag
MUX_SPRITES equ 73C7h ; Multiplexing sprites flag
RAND_NUM equ 73C8h ; Pseudo random number value
QUEUE_SIZE equ 73CAh ; Size of the deferred write queue
QUEUE_HEAD equ 73CBh ; Indice of the head of the write queue
QUEUE_TAIL equ 73CCh ; Indice of the tail of the write queue
HEAD_ADDRESS equ 73CDh ; Address of the queue head
TAIL_ADDRESS equ 73CFh ; Address of the queue tail
BUFFER equ 73D1h ; Buffer pointer to deferred objects
TIMER_TABLE_BASE equ 73D3h ; Timer base address
NEXT_TIMER_DATA_BYTE equ 73D5h ; Next available timer address
DBNCE_BUFF equ 73D7h ; 73D7-73EA = Debounce buffer. 5 pairs (old and state) of fire, joy, spin, arm and kbd for each player.
SPIN_SW0_CT equ 73EBh ; Spinner counter port#1
SPIN_SW1_CT equ 73ECh ; Spinner counter port#2
;73ED - (reserved)
S0_C0 equ 73EEh ; Segment 0 data, Controller port #1
S0_C1 equ 73EFh ; Segment 0 data, Controller port #2
S1_C0 equ 73F0h ; Segment 1 data, Controller port #1
S1_C1 equ 73F1h ; Segment 1 data, Controller port #2
VRAM_ADDR_TABLE equ 73F2h ;73F2-73FB  Block of VRAM table pointers
SPRITENAMETBL equ 73F2h ; Sprite name table offset
SPRITEGENTBL equ 73F4h ; Sprite generator table offset
PATTERNNAMETBL equ 73F6h ; Pattern name table offset
PATTERNGENTBL equ 73F8h ; Pattern generator table offset
COLORTABLE equ 73FAh ; Color table offset
SAVE_TEMP equ 73FCh ; (no more used - in VRAM routines)
SAVED_COUNT equ 73FEh ; Copy of COUNT for PUT_VRAM & GET_VRAM
